/**
* Script: vector.js
* Written by: Radnen
* Updated: 8/22/2010
**/

/**
* Vector:
*  - used to keep track of 2D velocities or positions.
/**/
function Vector(x, y)
{
	this.x = x;
	this.y = y;
	
	/**
	* read only: length;
	*  - returns the magnitude of this vector.
	**/
	this.__defineGetter__("length", function() {
		return Math.sqrt(this.x*this.x + this.y*this.y);
	});
	
	/**
	* dot(vect);
	*  - returns the dot product of this and another vector.
	**/
	this.dot = function(vect) {
		return this.x*vect.x + this.y*vect.y;
	}
	
	/**
	* add(v);
	*  - adds vector 'v' to this vector.
	**/
	this.add = function(v) {
		this.x += v.x;
		this.y += v.y;
	}
	
	/**
	* subtract(v);
	*  - subtracts vector 'v' from this vector.
	**/
	this.subtract = function(v) {
		this.x -= v.x;
		this.y -= v.y;
	}
	
	/**
	* scale(num);
	*  - scales this vector by the scalar 'num'.
	**/
	this.scale = function(num) {
		this.x *= num;
		this.y *= num;
	}
	
	/**
	* clone();
	*  - returns a copy of this vector.
	**/
	this.clone = function() {
		return new Vector(this.x, this.y);
	}
	
	/**
	* rotate(r);
	*  - rotates this vector by 'r' radians.
	**/
	this.rotate = function(r) {
		var a_cos = Math.cos(r), a_sin = Math.sin(r);
		var x = this.x*a_cos - this.y*a_sin;
		var y = this.x*a_sin + this.y*a_cos;
		this.x = x;
		this.y = y;
	}
}